<?php
App::uses('AppController', 'Controller');
App::uses('CakeEmail', 'Network/Email');

class FormsController extends AppController
{
    public function beforeFilter()
    {
        parent::beforeFilter();
        $this->Auth->allow('contact');
        $this->Security->unlockedActions = array('contact');
    }

    public function contact()
    {
        $this->autoRender = false;

        $content = array(
            'status' => 'error',
            'message' => '<div class="alert alert-warning" role="alert">' . __('Something unexpected occured.') . '</div>'
        );

        if ($this->request->isAjax()) {
            sleep(1);

            if (isset_recaptcha() && !$this->Recaptcha->verify($this->request->data['g-recaptcha-response'])) {
                $error = array(
                    'status' => 'error',
                    'message' => $this->Recaptcha->error,
                    'errors' => ''
                );
            }

            $this->Form->set($this->request->data);


            if ($this->Form->validates()) {
                $Email = new CakeEmail();
                $Email->template('contact', 'app');
                $Email->viewVars(array(
                    'contact_name' => $this->request->data['Form']['contact_name'],
                    'contact_email' => $this->request->data['Form']['contact_email'],
                    'contact_subject' => $this->request->data['Form']['contact_subject'],
                    'contact_message' => $this->request->data['Form']['contact_message']
                ));
                $Email->from($this->request->data['Form']['contact_email']);
                $Email->to(Configure::read('Option.admin_email'));
                $Email->emailFormat('html');
                $Email->subject(__('%s : Contact', Configure::read('Option.site_name')));
                $Email->send();

                $content = array(
                    'status' => 'success',
                    'message' => __('Your message has been sent.')
                );
            } else {
                $Form = $this->Form->invalidFields();
                $error = array(
                    'status' => 'error',
                    'message' => __('The Message could not be sent. Check the above errors.'),
                    'errors' => compact('Form')
                );
            }

            if (isset($error)) {
                $content = $error;
            }
        }
        echo json_encode($content);
    }
}
